#ifndef VIDEOHELPER_H
#define VIDEOHELPER_H

#include <QString>
#include <QStringList>

/*!
	\class VideoHelper
	\brief Collection of functions for manipulating video files. Using ffmpeg and mp4box from command line to extract video and audio stream data from file

*/

class VideoHelper
{
public:

	static bool		GetSingleVideoFileInfo(QString strVideoFilePath, QString &strVideoFrameSize, int &nVideoBitrate,QString &strAuxData, QString &strFPS, QString &strDAR, int &nAudioBitrate, int &nAudioFrequency, QString &strVideoCodec, QString &strAudioCodec, int &nAudioChannels);
	static bool		ConvertToMpeg_Resize(QStringList lstFilesIn,QStringList &lstFilesOut, QString strSize, QString strFPS,QString strDAR, int nAudioBitRate, int nAudioFreq);
	static bool		ConvertToMp4_Resize(QStringList lstFilesIn,QStringList &lstFilesOut, QString strSize, QString strFPS,QString strDAR, int nVideoBitRateMp4,int nAudioBitRate, int nAudioFreq);
	static bool		ConvertToMp4Fast(QString strFileIn,QString strFileOut);
	static bool		ConvertToMp4Fast_Batch(QStringList lstFilesIn,QStringList lstVideoCodecs, QStringList &lstFilesOut, QStringList &lstActaullyConvertedFilesOut);
	static bool		ConvertToMp4(QString strFileIn,QString strFileOut, int nVideoBitRateMp4, int nAudioBitRate, int nAudioFreq, bool bEncodeAudio);
	static QString	GetMostCommonSize(QStringList &lstSizes, QStringList &lstData,bool &bDifferentSizesExists);
	static bool		MergeMpeg(QStringList lstFilesIn, QString strFileOut);
	static bool		MergeMp4(QStringList lstFilesIn, QString strFileOut);

private:
	static bool		MergeMp4WithMkvMerge(QStringList lstFilesIn, QString strFileOut);
	static bool		MergeMp4WithMP4Box(QStringList lstFilesIn, QString strFileOut);
	
};

#endif // VIDEOHELPER_H
