#include "videohelper.h"
#include <QFileInfo>
#include <QCoreApplication>
#include <QProcess>
#include <QDir>

#include "shellmanager.h"
extern ShellManager *g_ShellManager;

#define USE_MP4BOX_FOR_MERGE 0 //if 1 then use mp4box (shitty prog->result has artifacts), else use mkvmerge (excellent)


/*!
	Extract video and audio data from strVideoFilePath
*/
bool VideoHelper::GetSingleVideoFileInfo(QString strVideoFilePath, QString &strVideoFrameSize, int &nVideoBitrate,QString &strAuxData, QString &strFPS, QString &strDAR, int &nAudioBitrate, int &nAudioFrequency, QString &strVideoCodec, QString &strAudioCodec, int &nAudioChannels)
{
	nAudioBitrate=0;
	nAudioFrequency=0;
	QFileInfo info(strVideoFilePath);

	QStringList lstArgs;
	lstArgs << "-i";
	lstArgs << strVideoFilePath;

	if(!g_ShellManager->ExecuteShellCommand("ffmpeg",lstArgs,true))
		return false;
	QByteArray errContent=g_ShellManager->GetCmdShellStdErrOutput();


	//parse size:
	QString strSize;
	if (info.suffix().toLower()=="flv")
	{
		int nIdx=errContent.indexOf("Video:");
		strVideoCodec=errContent.mid(nIdx+QString("Video:").length(),errContent.indexOf(",", nIdx+1)-nIdx-QString("Video:").length()).trimmed().toUpper();

		nIdx=errContent.indexOf(",", nIdx+1);
		nIdx=errContent.indexOf(",", nIdx+1);
		if (nIdx>0)
		{
			int i;
			nIdx++;
			for (i=nIdx;i<nIdx+30;i++)
			{
				if (errContent.at(i) == ',')
				{
					break;
				}
			}
			strSize=errContent.mid(nIdx+1,i-nIdx-1).trimmed();
			if (strSize.indexOf("["))
			{
				nIdx=errContent.indexOf("DAR", nIdx+1);
				if (nIdx>=0)
				{
					int x=errContent.indexOf("]", nIdx+1);
					if (x>nIdx)
					{
						strDAR=errContent.mid(nIdx+4,x-nIdx-4).trimmed();
					}
				}
				strSize = strSize.left(strSize.indexOf("[")).trimmed();
			}
		}
		strVideoFrameSize=strSize;
	}
	else
	{
		int nIdx=errContent.indexOf("Video:");
		strVideoCodec=errContent.mid(nIdx+QString("Video:").length(),errContent.indexOf(",", nIdx+1)-nIdx-QString("Video:").length()).trimmed().toUpper();


		nIdx=errContent.indexOf(",", nIdx+1);
		nIdx=errContent.indexOf(",", nIdx+1);
		if (nIdx>0)
		{
			//advance to next ",", check if already end or something of [PAR...
			int nIdx2=errContent.indexOf(",", nIdx+1);
			if (nIdx2>nIdx)
			{
				strSize=errContent.mid(nIdx+1,nIdx2-nIdx-1).trimmed();
				if (strSize.contains("["))
				{
					strSize = strSize.left(strSize.indexOf("[")).trimmed();
				}
				QStringList lstParts=strSize.toLower().split("x");
				if (lstParts.size()==2)
				{
					bool bOk=false;
					lstParts.at(0).toInt(&bOk);
					if (bOk)
						lstParts.at(0).toInt(&bOk);
					if (!bOk)
						strSize="";
				}
			}
		}
		strVideoFrameSize=strSize;
	}



	//parse bitrate:
	int nIdxVid=errContent.indexOf("Video:");
	int nIdx=errContent.indexOf("kb/s", nIdxVid);
	if (nIdx>0)
		if (errContent.mid(nIdxVid,nIdx-nIdxVid).contains("Audio"))
			nIdx=-1; //we found kbs of audio stream

	QString strBitrate;
	if (nIdx>0)
	{
		int i;
		for (i=nIdx;i>=nIdx-20;i--)
		{
			if (errContent.at(i) == ',')
			{
				break;
			}
		}
		strBitrate=errContent.mid(i+1,nIdx-i-1).trimmed();
		nVideoBitrate=strBitrate.toInt();


		//extract all data after kb/s: fps, tbc, etc...
		int nEof=errContent.indexOf("\n",nIdx);
		if (nEof>nIdx)
		{
			strAuxData=errContent.mid(nIdx+5,nEof-nIdx-6).trimmed();
		}
		else
			strAuxData="";

	}
	else
	{
		//try once more with bitrate keyword:
		int nIdxBitRate=errContent.indexOf("bitrate:");
		if (nIdxBitRate>0)
		{
			nIdxBitRate+=QString("bitrate:").length();
			int nIdxBitRateEnd=errContent.indexOf("kb/s",nIdxBitRate);
			strBitrate=errContent.mid(nIdxBitRate,nIdxBitRateEnd-nIdxBitRate).trimmed();
			nVideoBitrate=strBitrate.toInt();
		}
		else
		{
			nVideoBitrate=0;
			strAuxData="";
		}
	}


	if (info.suffix().toLower()=="flv")
	{
		if (strFPS.isEmpty())
		{
			int nIdx=errContent.indexOf("framerate");
			nIdx=errContent.indexOf(":", nIdx);
			QString strBitrate;
			if (nIdx>0)
			{
				int i;
				nIdx++;
				for (i=nIdx;i<nIdx+20;i++)
				{
					if (errContent.at(i) == '\n')
					{
						break;
					}
				}
				strFPS=errContent.mid(nIdx,i-nIdx-1).trimmed();
			}
		}
	}
	else
	{
		if (strFPS.isEmpty())
		{
			int nIdx=errContent.indexOf("Video:");
			nIdx=errContent.indexOf("fps", nIdx);
			QString strBitrate;
			if (nIdx>0)
			{
				int i;
				for (i=nIdx;i>=nIdx-20;i--)
				{
					if (errContent.at(i) == ',')
					{
						break;
					}
				}
				strFPS=errContent.mid(i+1,nIdx-i-1).trimmed();
			}
			else //for avi just look up tbr;
			{
				nIdx=errContent.indexOf("Video:");
				nIdx=errContent.indexOf(" tbr", nIdx);
				int i;
				if (nIdx>0)
				{
					for (i=nIdx;i>=nIdx-20;i--)
					{
						if (errContent.at(i) == ',')
						{
							break;
						}
					}
					strFPS=errContent.mid(i+1,nIdx-i-1).trimmed();
				}

			}
		}



	}

	if (info.suffix().toLower()=="flv")
	{
		if (strDAR.isEmpty())
		{
			//div h/w -> 1.333 on 3 decimals

			if (!strSize.isEmpty())
			{
				int nHeight=strSize.left(strSize.indexOf("x")).toInt();
				int nWidth=strSize.mid(strSize.indexOf("x")+1).toInt();

				double fDAR=(double)nHeight/nWidth;
				strDAR=QString::number(fDAR,'f',3);
			}
		}
	}
	else
	{
		if (strDAR.isEmpty())
		{
			int nIdx=errContent.indexOf("Video:");
			nIdx=errContent.indexOf("DAR", nIdx);
			QString strBitrate;
			if (nIdx>0)
			{
				int i;
				for (i=nIdx+4;i<=nIdx+20;i++)
				{
					if (errContent.at(i) == ']')
					{
						break;
					}
				}
				strDAR=errContent.mid(nIdx+4,i-nIdx-4).trimmed();
			}
		}
	}


	//extract audio information:
	nIdx=errContent.indexOf("Audio:");
	strAudioCodec=errContent.mid(nIdx+QString("Audio:").length(),errContent.indexOf(",", nIdx+1)-nIdx-QString("Audio:").length()).trimmed().toUpper();

	int nIdxLast=errContent.indexOf("\n", nIdx);
	QStringList lstAudioData=QString(errContent.mid(nIdx,nIdxLast-nIdx)).split(",");
	if (lstAudioData.size()>1)
	{
		QString strFreq=lstAudioData.at(1);
		QString strChannels=lstAudioData.at(2).trimmed();
		QString strBitRate=lstAudioData.at(lstAudioData.size()-1);
		if ( strBitRate.indexOf("kb/s")>=0)
			nAudioBitrate=strBitRate.replace("kb/s","").trimmed().toInt();
		else if (info.suffix().toLower()=="flv") 
		{
			int nIdx=errContent.indexOf("audiodatarate");
			nIdx=errContent.indexOf(":", nIdx);
			QString strBitrate;
			if (nIdx>0)
			{
				QString strAudioRate=errContent.mid(nIdx+1,(errContent.indexOf("\n",nIdx+1)-nIdx-1)).trimmed();
				nAudioBitrate=strAudioRate.toInt();
			}
		}
		nAudioFrequency=strFreq.replace("Hz","").trimmed().toInt();

		//channels:
		if (strChannels=="stereo")
			nAudioChannels=2;
		else if (strChannels=="mono")
			nAudioChannels=1;
		else
		{
			nAudioChannels=strChannels.trimmed().toInt();
			if (nAudioChannels==0)
			{
				nAudioChannels=strChannels.replace("channels","").trimmed().toInt();
				if (nAudioChannels==0)
					nAudioChannels=2;
			}
		}
	}


	if (nAudioBitrate==0)
		nAudioBitrate=64;

	if (nAudioFrequency==0)
		nAudioFrequency=22500;

	if (strFPS.isEmpty()) //check if FPS exists, if not then parse failed
		return false;
	else
		return true;
}


/*
	Converts each file to mpeg format (approx 5x greater then mp4 or flv original)
	Mpeg video files can be merged by DOS command: copy  /b f1+f2+f3 out.mpg
	Result will have wrong duration time-> re-encode back to mp4

	Returns false and aborts if one failed to convert

	Files will have same audio freq & audio and video bitrate, video fps and aspect ratio (DAR). MPG files must have specific values for Audiobitrate (64,92,128,192, etc..)
*/

bool VideoHelper::ConvertToMpeg_Resize(QStringList lstFilesIn,QStringList &lstFilesOut, QString strSize, QString strFPS,QString strDAR, int nAudioBitRate, int nAudioFreq)
{

	//Added on 24.02.2011/v3.1: mpeg1 does not support 15/1 fps, set minimum at 20 fps if below
	if (strFPS.toDouble()<20)
	{
		strFPS="20";
	}


	for (int i =0;i<lstFilesIn.size();i++)
	{
		QFileInfo info(lstFilesIn.at(i));
		//this->statusBar()->showMessage(("Converting: "+info.fileName()));
		//QCoreApplication::processEvents(QEventLoop::ExcludeUserInputEvents);

		QProcessEnvironment env;
		env.insert("HOME","ffpresets");

		QStringList lstArgs;
		lstArgs << "-i";
		lstArgs << lstFilesIn.at(i);
		lstArgs << "-sameq";

	
		if (!strDAR.isEmpty())
		{
			lstArgs << "-aspect";
			lstArgs << strDAR;
		}
		if (!strSize.isEmpty())
		{
			lstArgs << "-s";
			lstArgs << strSize;
		}
		if (!strFPS.isEmpty())
		{
			lstArgs << "-r";
			lstArgs << strFPS;
		}

		lstArgs << "-ac";
		lstArgs << "2";
		lstArgs << "-ab";
		lstArgs << QString::number(nAudioBitRate)+"k";
		lstArgs << "-ar";
		lstArgs << QString::number(nAudioFreq);
		

		QString strTemp;
		strTemp=QDir::tempPath()+"/"+info.baseName()+"_temp_"+QString::number(i)+".mpg";

		QFile::remove(strTemp);

		lstFilesOut << strTemp;
		lstArgs << strTemp;


		g_ShellManager->StartShellCommand("ffmpeg",lstArgs);
		if(!g_ShellManager->WaitForCmdShellToFinish(strTemp,5*info.size(),"Converting: "+info.fileName())) //4x approx target size-> only for progress
			return false;
	}

	return true;

}


/*
	Converts each file to mp4 format: problem with audio stream: when merged, audio is out of sync
*/

bool VideoHelper::ConvertToMp4_Resize(QStringList lstFilesIn,QStringList &lstFilesOut, QString strSize, QString strFPS,QString strDAR, int nVideoBitRateMp4, int nAudioBitRate, int nAudioFreq)
{

	for (int i =0;i<lstFilesIn.size();i++)
	{
		QFileInfo info(lstFilesIn.at(i));

		QStringList lstArgs;
		lstArgs << "-i";
		lstArgs << lstFilesIn.at(i);;
		lstArgs << "-vcodec";
		lstArgs << "libx264";
		lstArgs << "-b";
		lstArgs << QString::number(nVideoBitRateMp4)+"k";

		lstArgs << "-vpre";
		lstArgs << "superfast";			//using superfast preset
		lstArgs << "-threads";
		lstArgs << "0";					//using all cores: only available for libx264 codec
	
		if (!strDAR.isEmpty())
		{
			lstArgs << "-aspect";
			lstArgs << strDAR;
		}
		if (!strSize.isEmpty())
		{
			lstArgs << "-s";
			lstArgs << strSize;
		}
		if (!strFPS.isEmpty())
		{
			lstArgs << "-r";
			lstArgs << strFPS;
		}

		lstArgs << "-acodec";
		lstArgs << "libmp3lame";
		lstArgs << "-ab";
		lstArgs << QString::number(nAudioBitRate)+"k";
		lstArgs << "-ar";
		lstArgs << QString::number(nAudioFreq);
		lstArgs << "-ac";
		lstArgs << "2";
		

		QString strTemp;
		strTemp=QDir::tempPath()+"/"+info.baseName()+"_temp_"+QString::number(i)+".mp4";

		QFile::remove(strTemp);

		lstFilesOut << strTemp;
		lstArgs << strTemp;


		g_ShellManager->StartShellCommand("ffmpeg",lstArgs);
		if(!g_ShellManager->WaitForCmdShellToFinish(strTemp,1.2*info.size(),"Converting: "+info.fileName())) //4x approx target size-> only for progress
			return false;
	}

	return true;

}

bool VideoHelper::ConvertToMp4Fast(QString strFileIn,QString strFileOut)
{
	QStringList lstArgs;
	lstArgs << "-i";
	lstArgs << strFileIn;
	lstArgs << "-vcodec";
	lstArgs << "copy";
	lstArgs << "-acodec";
	lstArgs << "copy";


	lstArgs << strFileOut;

	QFileInfo info(strFileIn);

	g_ShellManager->StartShellCommand("ffmpeg",lstArgs);
	if(!g_ShellManager->WaitForCmdShellToFinish(strFileOut,1.2*info.size(),"Converting: "+info.fileName())) //1.2x approx target size
		return false;

	return true;
}

/*
	Converts only FLV files to the mp4 and only if FLV contains h264 stream
	Returns new temporary mp4 files if created along with unchanged in same order in return list
*/

bool VideoHelper::ConvertToMp4Fast_Batch(QStringList lstFilesIn,QStringList lstVideoCodecs, QStringList &lstFilesOut, QStringList &lstActaullyConvertedFilesOut)
{
	lstFilesOut.clear();
	lstActaullyConvertedFilesOut.clear();

	for (int i =0;i<lstFilesIn.size();i++)
	{
		QString strFileIn = lstFilesIn.at(i);
		QFileInfo info(strFileIn);

		//only files that are not already inside mp4 container and have h264 stream inside
		if(info.suffix().toLower().right(3)!="mp4" && lstVideoCodecs.at(i).indexOf("264")>=0)
		{
			//assemble output filename in temp path, delete if by accident already exists
			QString strFileOut=QDir::tempPath()+"/"+info.baseName()+"_temp_mp4_"+QString::number(i)+".mp4";
			QFile::remove(strFileOut);

			if(!ConvertToMp4Fast(lstFilesIn.at(i),strFileOut))
				return false;

			lstFilesOut<<strFileOut;
			lstActaullyConvertedFilesOut<<strFileOut; //store in this list only that are actaully converted
		}
		else
			lstFilesOut<<strFileIn;
	}

	return true;
}



//Note: for some reason aac and ac3 can not properly convert mp2 audio stream back to the aac/ac3 -> leave as is for future, some extra overhead..but it's ok!
bool VideoHelper::ConvertToMp4(QString strFileIn,QString strFileOut, int nVideoBitRateMp4, int nAudioBitRate, int nAudioFreq, bool bEncodeAudio)
{
	QStringList lstArgs;
	lstArgs << "-i";
	lstArgs << strFileIn;
	lstArgs << "-vcodec";
	lstArgs << "libx264";
	lstArgs << "-b";
	lstArgs << QString::number(nVideoBitRateMp4)+"k";

	lstArgs << "-vpre";
	lstArgs << "superfast";			//using superfast preset
	lstArgs << "-threads";
	lstArgs << "0";					//using all cores: only available for libx264 codec

	//NOTE: can not re-sample audio properly-> so just copy mp2 stream
	if (bEncodeAudio)
	{
		lstArgs << "-acodec";
		lstArgs << "libmp3lame";
		lstArgs << "-ab";
		lstArgs << QString::number(nAudioBitRate)+"k";
		lstArgs << "-ar";
		lstArgs << QString::number(nAudioFreq);
		lstArgs << "-ac";
		lstArgs << "2";
	}
	else
	{
		lstArgs << "-acodec";
		lstArgs << "copy";
	}

	lstArgs << strFileOut;
	
	QFileInfo info(strFileIn);

	int nTargetFileSize=info.size();
	if(info.suffix().toLower().right(3)=="mpg" || info.suffix().toLower().right(3)=="mpeg")
	{
		nTargetFileSize=nTargetFileSize/2; //at least 2x smaller then mpg, else all same
	}

	g_ShellManager->StartShellCommand("ffmpeg",lstArgs);
	if(!g_ShellManager->WaitForCmdShellToFinish(strFileOut,nTargetFileSize,"Converting: "+info.fileName())) // 1/4x approx target size
		return false;


	return true;
}





//lstSizes contains sizes in format 320x240, find most common size and return it
//bDifferentSizesExists returned true if not all sizes same
//lstData contains DAR information: video file can be same size but different DAR and it must be encoded
QString VideoHelper::GetMostCommonSize(QStringList &lstSizes, QStringList &lstData,bool &bDifferentSizesExists)
{
	lstSizes.sort();
	int nMax=0;
	QString strMaxSize="";
	bDifferentSizesExists=false;
	for (int i =0;i<lstSizes.size();i++)
	{
		if (lstSizes.at(i).isEmpty())
			continue;

		int nCurrentCnt=1;
		int k;
		for (k=i+1;k<lstSizes.size();k++)
		{
			if (lstSizes.at(k)==lstSizes.at(i))
				nCurrentCnt++;
			else
			{
				bDifferentSizesExists=true;
				break;
			}
		}

		if (nMax<nCurrentCnt)
		{
			nMax=nCurrentCnt;
			strMaxSize=lstSizes.at(i);
		}

		i=k-1;
	}

	if (!bDifferentSizesExists)
	{
		for (int i =0;i<lstData.size();i++)
		{
			int k;
			for (k=i+1;k<lstSizes.size();k++)
			{
				if (lstSizes.at(k)!=lstSizes.at(i))
				{
					bDifferentSizesExists=true;
					break;
				}
			}
			i=k-1;
		}
	}


	return strMaxSize;
}


bool VideoHelper::MergeMpeg(QStringList lstFilesIn, QString strFileOut)
{
	if (lstFilesIn.size()==0)
		return true;

	QStringList lstArgs;
	quint64 nTotalFileSize = 0; //total file size is approx size of merged file

	//use DOS command to merge file then re-encode back to mp4
	lstArgs <<"/C";
	lstArgs <<"copy";
	lstArgs <<"/b";
	for (int i =0;i<lstFilesIn.size();i++)
	{
		lstArgs << QDir::toNativeSeparators(lstFilesIn.at(i)); //QT stores paths with "/"
		if (i!=lstFilesIn.size()-1)
			lstArgs << "+";

		QFileInfo info(lstFilesIn.at(i));
		nTotalFileSize +=info.size();
	}

	lstArgs << QDir::toNativeSeparators(strFileOut);

	g_ShellManager->StartShellCommand("cmd.exe",lstArgs);
	if(!g_ShellManager->WaitForCmdShellToFinish(strFileOut,nTotalFileSize,"Merging file: "+strFileOut)) 
		return false;

	return true;

}



bool VideoHelper::MergeMp4(QStringList lstFilesIn, QString strFileOut)
{

#if USE_MP4BOX_FOR_MERGE
	return MergeMp4WithMP4Box(lstFilesIn,strFileOut);
#else
	return MergeMp4WithMkvMerge(lstFilesIn,strFileOut);
#endif
}



//command line switches from MKVMerge GUI
//test track order: audio and video must be in right pos
bool VideoHelper::MergeMp4WithMkvMerge(QStringList lstFilesIn, QString strFileOut)
{
	if (lstFilesIn.size()==0)
		return true;

	QStringList lstArgs;
	quint64 nTotalFileSize = 0;

	lstArgs << "-o"; 
	lstArgs << strFileOut;
	lstArgs << "--forced-track";
	lstArgs << "1:no";
	lstArgs << "--forced-track";
	lstArgs << "2:no";

	QString strAppendVideoTrack="";
	QString strAppendAudioTrack="";
	for (int i =0;i<lstFilesIn.size();i++)
	{
		//lstArgs << "-a";
		//lstArgs << "1";
		//lstArgs << "-d";
		//lstArgs << "2";
		lstArgs << "-S";
		lstArgs << "-T";
		lstArgs << "--no-global-tags";
		lstArgs << "--no-chapters";
		
		if (i>0)
		{
			lstArgs << "+"+lstFilesIn.at(i);
			strAppendVideoTrack+=QString::number(i)+":1:"+QString::number(i-1)+":1,";
			strAppendAudioTrack+=QString::number(i)+":2:"+QString::number(i-1)+":2,";
		}
		else
			lstArgs << lstFilesIn.at(i);

		QFileInfo info(lstFilesIn.at(i));
		nTotalFileSize +=info.size();
	}

	strAppendVideoTrack.chop(1); //remove "," from last pos
	strAppendAudioTrack.chop(1); //remove "," from last pos


	lstArgs << "-q";
	lstArgs << "--track-order";
	lstArgs << "0:1,0:2";
	lstArgs << "--append-to";
	lstArgs << (strAppendVideoTrack+","+strAppendAudioTrack);

	QFile::remove(strFileOut); //remove temp file if exists
	
	g_ShellManager->StartShellCommand("mkvmerge",lstArgs);
	if(!g_ShellManager->WaitForCmdShellToFinish(strFileOut,nTotalFileSize,"Merging file: "+strFileOut,true)) 
		return false;

	return true;

}

bool VideoHelper::MergeMp4WithMP4Box(QStringList lstFilesIn, QString strFileOut)
{
	if (lstFilesIn.size()==0)
		return true;

	QFileInfo info(lstFilesIn.at(0));

	QStringList lstArgs;
	quint64 nTotalFileSize = info.size(); //total file size is approx size of merged file

	//use MP4box to merge files: if not re-encoded there is great chance that audio is in sync
	//compile list of files, every flv convert to the mp4:
	for (int i =1;i<lstFilesIn.size();i++)
	{
		lstArgs << "-cat";
		lstArgs << lstFilesIn.at(i);

		QFileInfo info(lstFilesIn.at(i));
		nTotalFileSize +=info.size();
	}
	lstArgs << strFileOut;

	//MP4Box has bug when using -cat f1 -cat f2, so to merge files, add 'em to the first file and etc...
	//copy first part and to 'em:
	if(!QFile::copy(lstFilesIn.at(0),strFileOut))
		return false;

	g_ShellManager->StartShellCommand("MP4Box",lstArgs);
	if(!g_ShellManager->WaitForCmdShellToFinish(strFileOut,nTotalFileSize,"Merging file: "+strFileOut)) 
		return false;

	return true;
}
