#ifndef SHELLMANAGER_H
#define SHELLMANAGER_H

#include <QObject>
#include <QWidget>
#include <QProcess>

/*!
	\class ShellManager
	\brief Collection of functions for executing shell comands

	Commands can be executed synchronously by ExecuteShellCommand() or asynchronously by StartShellCommand()
	WaitForCmdShellToFinish() will display progress dialog based on value on monitored file in async mode.

*/

class ShellManager : public QObject
{
	Q_OBJECT

public:
	ShellManager(QObject *parent);
	~ShellManager();

	bool		ExecuteShellCommand(QString strShellCommand, QStringList lstArgs, bool nIgnoreExitCode=false);
	void		StartShellCommand(QString strShellCommand, QStringList lstArgs);
	bool		WaitForCmdShellToFinish(QString strFilePathToCheckSize="", int nTargetSize=0, QString strProgressBarMsg="", bool bIgnoreErrorIfProgressActivated=false);
	QByteArray  GetCmdShellStdErrOutput(){return m_byteCmdShellStdErrOutput;};

private slots:
	void OnCommandShellProcessFinished(int errCode ,QProcess::ExitStatus status);
	void OnCommandShellProcessError( QProcess::ProcessError error);

private:
	static void Sleep(unsigned long miliseconds);
	
	QProcessEnvironment m_CmdShellEnv;
	QProcess			m_CmdShellProcess;
	QString				m_strLastErrorCmdShell;
	QString				m_strCmdShellApplicationName;
	bool				m_bErrorOccuredCmdShell;
	QByteArray			m_byteCmdShellStdErrOutput;

};

#endif // SHELLMANAGER_H
