#ifndef MERGEMP4_H
#define MERGEMP4_H

#include <QtGui/QMainWindow>
#include "ui_mergemp4.h"
#include <QDragEnterEvent>
#include <QDropEvent>
#include <QUrl>
#include <QProgressBar>

/*!
	\class MergeMp4
	\brief Main GUI window

	Code is divided between this GUI class and helper classes:
	VideoHelper  - class for manipulating video conversion (static)
	ShellManager - class for executing shell commands

	All A/V conversions are done using shell commands and external tools as ffmpeg and mp4box. 
	Unfortunately because of this, local character set is not supported (only ASCII).

	H264 encoder used is libx264, for audio AAC and AC3 encoders are used libaften and libfaac.  

	Author site:	www.mandrilo.com/index.php/mergemp4flv 
	License:		copyleft
	Date:			29.03.2012.
	Version:		3.2

*/


class MergeMp4 : public QMainWindow
{
	Q_OBJECT

public:
	MergeMp4(QWidget *parent = 0, Qt::WFlags flags = 0);
	~MergeMp4();

private slots:
	void on_btnAdd_clicked();
	void on_btnDelete_clicked();
	void on_btnBrowse_clicked();
	void on_btnMerge_clicked();
	void on_btnUp_clicked();
	void on_btnDown_clicked();
	void OnSignalFilesDropped(QList<QUrl>);
	void OnitemSelectionChanged();
	void on_btnClear_clicked();
	void OnPathLinkActivated ( const QString &strUrl);


private:
	void DoMerge();
	void DoAddFiles(QStringList lstFiles);
	bool AnaylizeFiles(QStringList lstFilePaths, bool &bNeed2Convert, QString &strFrameSize,QString &strFPS,QString &strDAR,int &nVideoBitRateMp4,int &nAudioBitRateMp4,int &nAudioBitRateMpg,int &nAudioFrequency,QStringList &lstVideoCodecs);

	QProgressBar		*m_ProgresBar;
	Ui::MergeMp4Class	ui;
	QString				m_strPath;
	QString				m_strPathOut;
};




#endif // MERGEMP4_H
