#ifndef FILESTABLEWIDGET_H
#define FILESTABLEWIDGET_H

#include <QTableWidget>
#include <QString>
#include <QDragEnterEvent>
#include <QDropEvent>
#include <QUrl>
#include <QItemDelegate>


/*!
	\class FilesTableWidget
	\brief GUI representation of video file list
*/

class FilesTableWidget : public QTableWidget
{
	Q_OBJECT

public:
	FilesTableWidget(QWidget *parent);
	~FilesTableWidget();


	void AddFile(QString strFile,QString strVCodec,QString strBitrate,QString strSize, QString strACodec,QString strAFreq,QString strAChannels);
	void DeleteAll();
	void DeleteSelected();
	void MoveUpSelected();
	void MoveDownSelected();

signals:
	void SignalFilesDropped(QList<QUrl>);

protected:
	Qt::DropActions	supportedDropActions() const;
	void			dropEvent(QDropEvent *event);
	void			dragEnterEvent ( QDragEnterEvent * event );
	void			dragMoveEvent ( QDragMoveEvent * event );

private:
	
};


class DummyNoFocusDelegate : public QItemDelegate
{
public:
	DummyNoFocusDelegate::DummyNoFocusDelegate(QObject *parent):QItemDelegate(parent){};
	void drawFocus ( QPainter * painter, const QStyleOptionViewItem & option, const QRect & rect ) const {};
};


#endif // FILESTABLEWIDGET_H
