#include "filestablewidget.h"
#include <QHeaderView>
#include <QTableWidgetItem>

#define COL_FILE_NAME		0
#define COL_VIDEO_CODEC		1
#define COL_VIDEO_BITRATE	2
#define COL_VIDEO_SIZE		3
#define COL_AUDIO_CODEC		4
#define COL_AUDIO_FREQ		5
#define COL_AUDIO_CHANNELS	6



FilesTableWidget::FilesTableWidget(QWidget *parent)
	: QTableWidget(parent)
{

	//set gradient background
	
	QString	strParentObjectName="QTableView ";
	QString	strStyle;

	strStyle= strParentObjectName+"{show-decoration-selected: 1; color:black; selection-background-color:rgb(19,79,217); background:qradialgradient(cx:0.7, cy:0.3, radius: 0.8, fx:0.7, fy:0.3, stop:0 rgb(224,170,5), stop:1 rgb(170,59,29));}";
	strStyle+=strParentObjectName+"{border-style: solid; border-width: 1px 1px 1px 1px}";
	strStyle+=strParentObjectName+"{gridline-color: black}";
	strStyle+="QComboBox  {color: black; background:transparent;} QLineEdit {color: black;}";
	strStyle+="QTableView:disabled {background: rgb(6,70,79)}";
	strStyle+="QHeaderView:section {color: white; background:rgb(6,70,79);}"+strParentObjectName+" QTableCornerButton::section {background:rgb(6,70,79);border: 1px}  QHeaderView {background:transparent;}";

	this->setStyleSheet(strStyle);

	//set header columns
	setRowCount(0);
	horizontalHeader()->setDefaultSectionSize(85);  //rest are default
	QStringList lstHeader;
	lstHeader<<"File";
	lstHeader<<"Video Codec";
	lstHeader<<"Video Bitrate";
	lstHeader<<"Video Size";
	lstHeader<<"Audio Codec";
	lstHeader<<"Audio Freq";
	lstHeader<<"Audio Channels";
	setColumnCount(lstHeader.count());
	setHorizontalHeaderLabels (lstHeader);
	setColumnWidth(0,380); //set first width 

	//resize height of row=20
	verticalHeader()->setDefaultSectionSize(20);

	setSelectionBehavior( QAbstractItemView::SelectRows);  //select rows not single items
	setSelectionMode( QAbstractItemView::SingleSelection); //single selection

	setAcceptDrops(true);

	//avoid focus rectangle around table cell
	DummyNoFocusDelegate* DeafultTableDelegate = new DummyNoFocusDelegate(this);
	setItemDelegate (DeafultTableDelegate);

}

FilesTableWidget::~FilesTableWidget()
{

}

void FilesTableWidget::AddFile(QString strFile,QString strVCodec,QString strBitrate,QString strSize, QString strACodec,QString strAFreq,QString strAChannels)
{
	int nRow=rowCount()+1;
	setRowCount(nRow);

	QTableWidgetItem *item1 = new QTableWidgetItem(strFile);
	item1->setToolTip(strFile); //filename can be long so set tooltip
	setItem(nRow-1,COL_FILE_NAME, item1);

	setItem(nRow-1,COL_VIDEO_CODEC,new QTableWidgetItem(strVCodec));
	setItem(nRow-1,COL_VIDEO_BITRATE, new QTableWidgetItem(strBitrate));
	setItem(nRow-1,COL_VIDEO_SIZE, new QTableWidgetItem(strSize));
	setItem(nRow-1,COL_AUDIO_CODEC,new QTableWidgetItem(strACodec));
	setItem(nRow-1,COL_AUDIO_FREQ, new QTableWidgetItem(strAFreq));

	if (strAChannels=="1") 
		strAChannels="mono";
	else if (strAChannels=="2")
		strAChannels="stereo";
	setItem(nRow-1,COL_AUDIO_CHANNELS, new QTableWidgetItem(strAChannels));



	//set all items not editable:
	for (int i=0;i<columnCount();i++)
	{
		item(nRow-1,i)->setFlags(Qt::ItemIsDragEnabled | Qt::ItemIsDropEnabled | Qt::ItemIsSelectable | Qt::ItemIsEnabled);  //not editable;
	}

}

void FilesTableWidget::DeleteAll()
{
	clearContents();
	setRowCount(0);
}


void FilesTableWidget::DeleteSelected()
{
	QList<int> lstRowsForDelete;
	QList<QTableWidgetItem *> lstSelected = selectedItems();

	for (int i=0;i<lstSelected.size();i++)
	{
		if (lstSelected.at(i)->column()==COL_FILE_NAME)
		{
			lstRowsForDelete<<lstSelected.at(i)->row();
		}
	}

	//delete rows from end to keep correct row index, not needed for single row, but it's ok
	this->blockSignals(true); //prevent table to fire selection changed signal until rows are deleted completly
	qSort(lstRowsForDelete);
	for (int i=lstRowsForDelete.size()-1;i>=0;i--)
	{
		removeRow(lstRowsForDelete.at(i)); 
	}
	this->blockSignals(false);
}


void FilesTableWidget::MoveUpSelected()
{
	//if row = 0 , ignore, else, flip positions
	//find selected row (just one)
	QList<QTableWidgetItem *> lstSelected = selectedItems();
	int nRowSelected=0;
	for (int i=0;i<lstSelected.size();i++)
	{
		if (lstSelected.at(i)->column()==COL_FILE_NAME)
		{
			nRowSelected = lstSelected.at(i)->row();
			break;
		}
	}

	if (nRowSelected==0) //exit if first row, or nothing selected
		return; 

	this->blockSignals(true); //prevent table to fire selection changed signal until rows are deleted completly

	//take items from selected row
	QList<QTableWidgetItem*> lstItemsSource;
	for (int i=0;i<columnCount();i++)
	{
		lstItemsSource<<takeItem(nRowSelected,i);
	}

	//take items from row above
	QList<QTableWidgetItem*> lstItemsTarget;
	for (int i=0;i<columnCount();i++)
	{
		lstItemsTarget<<takeItem(nRowSelected-1,i);
	}

	//set items above
	for (int i=columnCount()-1;i>=0;i--)
	{
		setItem(nRowSelected-1,i,lstItemsSource.at(i));
		setCurrentItem(lstItemsSource.at(i));
	}

	//set items below
	for (int i=0;i<columnCount();i++)
	{
		setItem(nRowSelected,i,lstItemsTarget.at(i));
	}

	this->blockSignals(false); //prevent table to fire selection changed signal until rows are deleted completly
}

void FilesTableWidget::MoveDownSelected()
{

	//if row = 0 , ignore, else, flip positions
	//find selected row (just one)
	QList<QTableWidgetItem *> lstSelected = selectedItems();
	int nRowSelected=rowCount()-1;
	for (int i=0;i<lstSelected.size();i++)
	{
		if (lstSelected.at(i)->column()==COL_FILE_NAME)
		{
			nRowSelected = lstSelected.at(i)->row();
			break;
		}
	}

	if (nRowSelected==rowCount()-1) //exit if lsst row, or nothing selected
		return; 

	this->blockSignals(true); //prevent table to fire selection changed signal until rows are deleted completly

	//take items from selected row
	QList<QTableWidgetItem*> lstItemsSource;
	for (int i=0;i<columnCount();i++)
	{
		lstItemsSource<<takeItem(nRowSelected,i);
	}

	//take items from row below
	QList<QTableWidgetItem*> lstItemsTarget;
	for (int i=0;i<columnCount();i++)
	{
		lstItemsTarget<<takeItem(nRowSelected+1,i);
	}

	//set items below: go from last to set focus on first cell
	for (int i=columnCount()-1;i>=0;i--)
	{
		setItem(nRowSelected+1,i,lstItemsSource.at(i));
		setCurrentItem(lstItemsSource.at(i));
	}

	//set items above
	for (int i=0;i<columnCount();i++)
	{
		setItem(nRowSelected,i,lstItemsTarget.at(i));
	}

	this->blockSignals(false); //prevent table to fire selection changed signal until rows are deleted completly

}




Qt::DropActions FilesTableWidget::supportedDropActions() const 
{
	return  Qt::CopyAction | Qt::MoveAction | Qt::IgnoreAction | Qt::LinkAction | Qt::ActionMask | Qt::TargetMoveAction;
}
void FilesTableWidget::dragMoveEvent ( QDragMoveEvent * event )
{
	event->accept();
}
void FilesTableWidget::dragEnterEvent ( QDragEnterEvent * event )
{
	event->accept();
}


//if not edit mode: disable drop & drag
void FilesTableWidget::dropEvent(QDropEvent *event)
{
	const QMimeData *mime = event->mimeData();

	//------------------------------------------------
	// LIST of documents entities:
	//------------------------------------------------
	//internal/external
	if (mime->hasUrls()) 
	{
		QList<QUrl> lst =mime->urls();
		emit SignalFilesDropped(lst);
		event->accept();
		return;
	}

	event->ignore();
	return;
}
